/* header file for win.c                                 */
/*  by AKIKAWA, Hisashi 2015-2025                        */
/* This software is released under 2-clause BSD license. */

typedef unsigned int chtype;

typedef struct {
  HANDLE *winhandle;
  int _cury, _curx;
  int _maxx, _maxy;
  int _attrs;
  int _top, _bottom;

  int _scroll;
  int _nodelay;
  int _use_keypad;
} WINDOW;

typedef struct {
  int autocr;
  int echo;
} SCREEN;

typedef struct {
  int attr;
  wchar_t chars[5];
} cchar_t;

#define KEY_BREAK	0x101
#define KEY_DOWN	0x102
#define KEY_UP		0x103
#define KEY_LEFT	0x104
#define KEY_RIGHT	0x105
#define KEY_HOME	0x106
#define KEY_BACKSPACE	0x107
#define KEY_F(n)	(0x108+(n))
#define KEY_DC		0x14a
#define KEY_IC		0x14b
#define KEY_SF		0x150
#define KEY_SR		0x151
#define KEY_NPAGE	0x152
#define KEY_PPAGE	0x153
#define KEY_BTAB	0x15f
#define KEY_END		0x166
#define KEY_SDC		0x17d
#define KEY_SHOME	0x184
#define KEY_SLEFT	0x187
#define KEY_SPREVIOUS	0x18e
#define KEY_SRIGHT	0x190

#define OK (0)
#define ERR (-1)
#define A_NORMAL 0
#define A_REVERSE 0x00010000

WINDOW *initscr(void);
int endwin(void);
int wresize(WINDOW *win, int lines, int columns);
int nonl(void);
int noecho(void);
int raw(void);
int noraw(void);
int keypad(WINDOW *win, int bf);
int nodelay(WINDOW *win, int bf);
int scrollok(WINDOW *win, int bf);
int set_escdelay(int size);
int curs_set(int visibility);
int setscrreg(int top, int bot);
int getmaxy(WINDOW *win);
int move(int y, int x);
int addch(const chtype ch);
int add_wch(const cchar_t *wch);
int mvaddch(int y, int x, const chtype ch);
int mvadd_wch(int y, int x, const cchar_t *wch);
int setcchar(cchar_t *wch, const wchar_t *wc, const int attrs, short color_pair, void *opts);
int vwprintw(WINDOW *win, const char *fmt, va_list args);
int printw(const char *fmt, ...);
int mvprintw(int y, int x, const char *fmt, ...);
int clrtoeol(void);
void refresh(void);
int redrawwin(WINDOW *win);
int get_wch(wint_t *wch);
char *tilde_expand(char *fname);

#define attron(a) (stdscr ? (stdscr->_attrs |= (a)) : ERR)
#define attroff(a) (stdscr ? (stdscr->_attrs &= ~(a)) : ERR)
#define getyx(win, y, x) (x = win ? win->_curx : ERR, y = win ? win->_cury : ERR)
